@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h1 class="title1 ">Add Expert Trader</h1>
                        </div>
                        <div>
                            <a href="{{ route('plans') }}" class="btn btn-sm btn-primary"> <i class="fa fa-arrow-left"></i>
                                Back</a>
                        </div>
                    </div>
                </div>
                <x-danger-alert />
                <x-success-alert />
                <div class="mb-5 row">
                    <div class="col-lg-12 ">
                        <div class="p-3 card ">
                            <form role="form" method="post" action="{{ route('addplan') }}" enctype="multipart/form-data">
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <h5 class="">Trader Name</h5>
                                        <input class="form-control  " placeholder="Enter Trader name" type="text"
                                            name="name" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Trader price({{ $settings->currency }})</h5>
                                        <input class="form-control  " placeholder="Enter Trader price" type="number"
                                            name="price" required>
                                        <small class="">This is the maximum amount a user can pay
                                            to copy this Trader, enter the value without a comma(,)</small>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Trader Minimum Price
                                            ({{ $settings->currency }})</h5>
                                        <input placeholder="Enter Trader minimum price" class="form-control" type="number"
                                            name="min_price" required>
                                        <small class="">This is the minimum amount a user can pay
                                            to copy this Trader, enter the value without a comma(,)</small>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Trader Maximum Price
                                            ({{ $settings->currency }})</h5>
                                        <input class="form-control  " placeholder="Enter Trader maximum price" type="number"
                                            name="max_price" required>
                                        <small class="">Same as Trader price, enter the value without
                                            a comma(,)</small>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Minimum return (%)</h5>
                                        <input class="form-control" placeholder="Enter minimum return" type="number"
                                            step="any" name="minr" required>
                                        <small class="">This is the minimum return (ROI) for this
                                            Trader, enter the value without a comma(,)</small>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Maximum return (%)</h5>
                                        <input class="form-control  " placeholder="Enter maximum return" type="number"
                                            step="any" name="maxr" required>
                                        <small class="">This is the Maximum return (ROI) for this
                                            Trader, enter the value without a comma(,)</small>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Gift Bonus ({{ $settings->currency }})</h5>
                                        <input class="form-control" placeholder="Enter Additional Gift Bonus" type="number"
                                            step="any" name="gift" value="0" required>
                                        <small class="">Optional Bonus if a user buys this
                                            Trader.enter the value without a comma(,) </small>
                                    </div
                                    <div class="form-group col-md-6">
                                        <h5 class="">Trade Tag</h5>
                                        <input class="form-control" placeholder="Enter Trader Tag" type="text"
                                            step="any" name="tag"  value='{{ $plan->tag ?? '' }}' >
                                        <small class="">Optional Trader tag. This is  tags for each plan eg 'Popular' , 'VIP' etc
                                          </small>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Trades</h5>
                                        <input class="form-control" placeholder="Enter Trades" type="text"
                                             name="trades"  value='' >
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Copiers</h5>
                                        <input class="form-control" placeholder="Enter Copiers" type="text"
                                             name="copiers"  value=''>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Risks(%)</h5>
                                        <input class="form-control" placeholder="Enter risks" type="text"
                                             name="risk"  value=''>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Losses</h5>
                                        <input class="form-control" placeholder="Enter losses" type="text"
                                             name="losses"  value=''>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Country</h5>
                                        <select class="form-control" name="country">
                                            <option value="">Select a Country</option>
                                            <option value="Afghanistan">Afghanistan</option>
                                            <option value="Albania">Albania</option>
                                            <option value="Algeria">Algeria</option>
                                            <option value="Andorra">Andorra</option>
                                            <option value="Angola">Angola</option>
                                            <option value="Antigua and Barbuda">Antigua and Barbuda</option>
                                            <option value="Argentina">Argentina</option>
                                            <option value="Armenia">Armenia</option>
                                            <option value="Australia">Australia</option>
                                            <option value="Austria">Austria</option>
                                            <option value="Azerbaijan">Azerbaijan</option>
                                            <option value="Bahamas">Bahamas</option>
                                            <option value="Bahrain">Bahrain</option>
                                            <option value="Bangladesh">Bangladesh</option>
                                            <option value="Barbados">Barbados</option>
                                            <option value="Belarus">Belarus</option>
                                            <option value="Belgium">Belgium</option>
                                            <option value="Belize">Belize</option>
                                            <option value="Benin">Benin</option>
                                            <option value="Bhutan">Bhutan</option>
                                            <option value="Bolivia">Bolivia</option>
                                            <option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
                                            <option value="Botswana">Botswana</option>
                                            <option value="Brazil">Brazil</option>
                                            <option value="Brunei">Brunei</option>
                                            <option value="Bulgaria">Bulgaria</option>
                                            <option value="Burkina Faso">Burkina Faso</option>
                                            <option value="Burundi">Burundi</option>
                                            <option value="Cabo Verde">Cabo Verde</option>
                                            <option value="Cambodia">Cambodia</option>
                                            <option value="Cameroon">Cameroon</option>
                                            <option value="Canada">Canada</option>
                                            <option value="Central African Republic">Central African Republic</option>
                                            <option value="Chad">Chad</option>
                                            <option value="Chile">Chile</option>
                                            <option value="China">China</option>
                                            <option value="Colombia">Colombia</option>
                                            <option value="Comoros">Comoros</option>
                                            <option value="Congo (Congo-Brazzaville)">Congo (Congo-Brazzaville)</option>
                                            <option value="Costa Rica">Costa Rica</option>
                                            <option value="Croatia">Croatia</option>
                                            <option value="Cuba">Cuba</option>
                                            <option value="Cyprus">Cyprus</option>
                                            <option value="Czechia (Czech Republic)">Czechia (Czech Republic)</option>
                                            <option value="Democratic Republic of the Congo">Democratic Republic of the Congo</option>
                                            <option value="Denmark">Denmark</option>
                                            <option value="Djibouti">Djibouti</option>
                                            <option value="Dominica">Dominica</option>
                                            <option value="Dominican Republic">Dominican Republic</option>
                                            <option value="Ecuador">Ecuador</option>
                                            <option value="Egypt">Egypt</option>
                                            <option value="El Salvador">El Salvador</option>
                                            <option value="Equatorial Guinea">Equatorial Guinea</option>
                                            <option value="Eritrea">Eritrea</option>
                                            <option value="Estonia">Estonia</option>
                                            <option value="Eswatini">Eswatini</option>
                                            <option value="Ethiopia">Ethiopia</option>
                                            <option value="Fiji">Fiji</option>
                                            <option value="Finland">Finland</option>
                                            <option value="France">France</option>
                                            <option value="Gabon">Gabon</option>
                                            <option value="Gambia">Gambia</option>
                                            <option value="Georgia">Georgia</option>
                                            <option value="Germany">Germany</option>
                                            <option value="Ghana">Ghana</option>
                                            <option value="Greece">Greece</option>
                                            <option value="Grenada">Grenada</option>
                                            <option value="Guatemala">Guatemala</option>
                                            <option value="Guinea">Guinea</option>
                                            <option value="Guinea-Bissau">Guinea-Bissau</option>
                                            <option value="Guyana">Guyana</option>
                                            <option value="Haiti">Haiti</option>
                                            <option value="Honduras">Honduras</option>
                                            <option value="Hungary">Hungary</option>
                                            <option value="Iceland">Iceland</option>
                                            <option value="India">India</option>
                                            <option value="Indonesia">Indonesia</option>
                                            <option value="Iran">Iran</option>
                                            <option value="Iraq">Iraq</option>
                                            <option value="Ireland">Ireland</option>
                                            <option value="Israel">Israel</option>
                                            <option value="Italy">Italy</option>
                                            <option value="Jamaica">Jamaica</option>
                                            <option value="Japan">Japan</option>
                                            <option value="Jordan">Jordan</option>
                                            <option value="Kazakhstan">Kazakhstan</option>
                                            <option value="Kenya">Kenya</option>
                                            <option value="Kiribati">Kiribati</option>
                                            <option value="Kuwait">Kuwait</option>
                                            <option value="Kyrgyzstan">Kyrgyzstan</option>
                                            <option value="Laos">Laos</option>
                                            <option value="Latvia">Latvia</option>
                                            <option value="Lebanon">Lebanon</option>
                                            <option value="Lesotho">Lesotho</option>
                                            <option value="Liberia">Liberia</option>
                                            <option value="Libya">Libya</option>
                                            <option value="Liechtenstein">Liechtenstein</option>
                                            <option value="Lithuania">Lithuania</option>
                                            <option value="Luxembourg">Luxembourg</option>
                                            <option value="Madagascar">Madagascar</option>
                                            <option value="Malawi">Malawi</option>
                                            <option value="Malaysia">Malaysia</option>
                                            <option value="Maldives">Maldives</option>
                                            <option value="Mali">Mali</option>
                                            <option value="Malta">Malta</option>
                                            <option value="Marshall Islands">Marshall Islands</option>
                                            <option value="Mauritania">Mauritania</option>
                                            <option value="Mauritius">Mauritius</option>
                                            <option value="Mexico">Mexico</option>
                                            <option value="Micronesia">Micronesia</option>
                                            <option value="Moldova">Moldova</option>
                                            <option value="Monaco">Monaco</option>
                                            <option value="Mongolia">Mongolia</option>
                                            <option value="Montenegro">Montenegro</option>
                                            <option value="Morocco">Morocco</option>
                                            <option value="Mozambique">Mozambique</option>
                                            <option value="Myanmar (Burma)">Myanmar (Burma)</option>
                                            <option value="Namibia">Namibia</option>
                                            <option value="Nauru">Nauru</option>
                                            <option value="Nepal">Nepal</option>
                                            <option value="Netherlands">Netherlands</option>
                                            <option value="New Zealand">New Zealand</option>
                                            <option value="Nicaragua">Nicaragua</option>
                                            <option value="Niger">Niger</option>
                                            <option value="Nigeria">Nigeria</option>
                                            <option value="North Korea">North Korea</option>
                                            <option value="North Macedonia">North Macedonia</option>
                                            <option value="Norway">Norway</option>
                                            <option value="Oman">Oman</option>
                                            <option value="Pakistan">Pakistan</option>
                                            <option value="Palau">Palau</option>
                                            <option value="Palestine">Palestine</option>
                                            <option value="Panama">Panama</option>
                                            <option value="Papua New Guinea">Papua New Guinea</option>
                                            <option value="Paraguay">Paraguay</option>
                                            <option value="Peru">Peru</option>
                                            <option value="Philippines">Philippines</option>
                                            <option value="Poland">Poland</option>
                                            <option value="Portugal">Portugal</option>
                                            <option value="Qatar">Qatar</option>
                                            <option value="Romania">Romania</option>
                                            <option value="Russia">Russia</option>
                                            <option value="Rwanda">Rwanda</option>
                                            <option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
                                            <option value="Saint Lucia">Saint Lucia</option>
                                            <option value="Saint Vincent and the Grenadines">Saint Vincent and the Grenadines</option>
                                            <option value="Samoa">Samoa</option>
                                            <option value="San Marino">San Marino</option>
                                            <option value="Sao Tome and Principe">Sao Tome and Principe</option>
                                            <option value="Saudi Arabia">Saudi Arabia</option>
                                            <option value="Senegal">Senegal</option>
                                            <option value="Serbia">Serbia</option>
                                            <option value="Seychelles">Seychelles</option>
                                            <option value="Sierra Leone">Sierra Leone</option>
                                            <option value="Singapore">Singapore</option>
                                            <option value="Slovakia">Slovakia</option>
                                            <option value="Slovenia">Slovenia</option>
                                            <option value="Solomon Islands">Solomon Islands</option>
                                            <option value="Somalia">Somalia</option>
                                            <option value="South Africa">South Africa</option>
                                            <option value="South Korea">South Korea</option>
                                            <option value="South Sudan">South Sudan</option>
                                            <option value="Spain">Spain</option>
                                            <option value="Sri Lanka">Sri Lanka</option>
                                            <option value="Sudan">Sudan</option>
                                            <option value="Suriname">Suriname</option>
                                            <option value="Sweden">Sweden</option>
                                            <option value="Switzerland">Switzerland</option>
                                            <option value="Syria">Syria</option>
                                            <option value="Taiwan">Taiwan</option>
                                            <option value="Tajikistan">Tajikistan</option>
                                            <option value="Tanzania">Tanzania</option>
                                            <option value="Thailand">Thailand</option>
                                            <option value="Timor-Leste">Timor-Leste</option>
                                            <option value="Togo">Togo</option>
                                            <option value="Tonga">Tonga</option>
                                            <option value="Trinidad and Tobago">Trinidad and Tobago</option>
                                            <option value="Tunisia">Tunisia</option>
                                            <option value="Turkey">Turkey</option>
                                            <option value="Turkmenistan">Turkmenistan</option>
                                            <option value="Tuvalu">Tuvalu</option>
                                            <option value="Uganda">Uganda</option>
                                            <option value="Ukraine">Ukraine</option>
                                            <option value="United Arab Emirates">United Arab Emirates</option>
                                            <option value="United Kingdom">United Kingdom</option>
                                            <option value="United States">United States</option>
                                            <option value="Uruguay">Uruguay</option>
                                            <option value="Uzbekistan">Uzbekistan</option>
                                            <option value="Vanuatu">Vanuatu</option>
                                            <option value="Vatican City">Vatican City</option>
                                            <option value="Venezuela">Venezuela</option>
                                            <option value="Vietnam">Vietnam</option>
                                            <option value="Yemen">Yemen</option>
                                            <option value="Zambia">Zambia</option>
                                            <option value="Zimbabwe">Zimbabwe</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Trader Pic</h5>
                                        <input class="form-control" placeholder="Enter" type="file"
                                             name="image">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Ratings</h5>
                                        <input class="form-control" placeholder="Enter rating" type="text"
                                             name="rating" max="5"  value=''>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Trade Description</h5>
                                        <textarea name="descp" class="form-control"></textarea>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Top up Interval</h5>
                                        <select class="form-control  " name="t_interval">
                                            <option>Monthly</option>
                                            <option>Weekly</option>
                                            <option>Daily</option>
                                            <option>Hourly</option>
                                            <option>Every 30 Minutes</option>
                                            <option>Every 10 Minutes</option>
                                        </select>
                                        <small class="">
                                            This specifies how often the system should add profit(ROI) to user account.
                                        </small>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <h5 class="">Top up Type</h5>
                                        <select class="form-control  " name="t_type">
                                            <option>Percentage</option>
                                            <option>Fixed</option>
                                        </select>
                                        <small class="">This specifies if the system should add
                                            profit in percentage(%) or a fixed amount.</small>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <h5 class="">Top up Amount (in % or
                                            {{ $settings->currency }} as specified above)</h5>
                                        <input class="form-control  " placeholder="top up amount" type="number"
                                            step="any" name="t_amount" required>
                                        <small class="">This is the amount the system will add to
                                            users account as profit, based on what you selected in topup type and topup
                                            interval above.</small>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <h5 class="">Investment Duration</h5>
                                        <input class="form-control" placeholder="eg 1 Days, 2 Weeks, 1 Months"
                                            type="text" name="expiration" required>
                                        <small class="">This specifies how long the investment Trading
                                            will run. Please strictly follow the guide on <a href=""
                                                data-toggle="modal" data-target="#durationModal">how to setup trader
                                                duration</a> else it may not work. </small>

                                    </div>
                                    <div class="form-group col-md-12">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <input type="submit" class="btn btn-primary" value="Add Trader">
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="durationModal" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-body ">
                        <h5 class="">FIRSTLY, Always preceed the time frame with a digit, that is
                            do not write the number in letters, <br> <br> SECONDLY, always add space after the number, <br>
                            <br> LASTLY, the first letter of the timeframe should be in CAPS and always add 's' to the
                            timeframe even if your duration is just a day, month or year.
                        </h5>
                        <h2 class="">Eg, 1 Days, 3 Weeks, 1 Hours, 48 Hours, 4 Months, 1 Years, 9
                            Months</h2>

                    </div>
                </div>
            </div>
        </div>
        <div id="topupModal" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-body ">

                    </div>
                </div>
            </div>
        </div>

        <script>
            function getduration(id, event) {
                event.preventDefault();
                document.getElementById('duridden').value = id;
            }
        </script>
    @endsection
